import { Battery, MessageCircle, CreditCard } from "lucide-react"

export function ThreeStepsSection() {
  return (
    <section id="pasos" className="py-16 bg-gray-100">
      <div className="container mx-auto px-4">
        <h2 className="text-3xl font-bold text-center text-black mb-4">OBTÉN TU BATERÍA IDEAL EN 3 SIMPLES PASOS</h2>

        <div className="grid md:grid-cols-3 gap-8 mt-12">
          {/* Step 1 */}
          <div className="text-center">
            <div className="bg-green-500 text-white rounded-full w-16 h-16 flex items-center justify-center text-2xl font-bold mx-auto mb-6">
              1
            </div>
            <div className="bg-white p-6 rounded-lg shadow-sm mb-4">
              <Battery className="w-12 h-12 text-gray-600 mx-auto" />
            </div>
            <p className="text-gray-700 font-medium">Encuentra tu batería según las características de tu vehículo</p>
          </div>

          {/* Step 2 */}
          <div className="text-center">
            <div className="bg-green-500 text-white rounded-full w-16 h-16 flex items-center justify-center text-2xl font-bold mx-auto mb-6">
              2
            </div>
            <div className="bg-white p-6 rounded-lg shadow-sm mb-4">
              <MessageCircle className="w-12 h-12 text-gray-600 mx-auto" />
            </div>
            <p className="text-gray-700 font-medium">Pídelo por WhatsApp</p>
          </div>

          {/* Step 3 */}
          <div className="text-center">
            <div className="bg-green-500 text-white rounded-full w-16 h-16 flex items-center justify-center text-2xl font-bold mx-auto mb-6">
              3
            </div>
            <div className="bg-white p-6 rounded-lg shadow-sm mb-4">
              <CreditCard className="w-12 h-12 text-gray-600 mx-auto" />
            </div>
            <p className="text-gray-700 font-medium">Elige el método de pago</p>
          </div>
        </div>
      </div>
    </section>
  )
}
