"use client"

import { Button } from "@/components/ui/button"
import { Card, CardContent } from "@/components/ui/card"
import { useCart } from "@/components/cart-context"
import Link from "next/link"

const batteries = [
  {
    id: "1",
    name: "ROCKET NS60LS",
    brand: "ROCKET",
    price: 390,
    image: "/rocket-battery-black-automotive.jpg",
    inStock: true,
  },
  {
    id: "2",
    name: "VARTA BLUE DYNAMIC",
    brand: "VARTA",
    price: 349,
    image: "/rocket-battery-black-automotive.jpg",
    inStock: true,
  },
  {
    id: "3",
    name: "AC DELCO PROFESSIONAL",
    brand: "AC DELCO",
    price: 279,
    image: "/black-car-battery-rocket-brand.jpg",
    inStock: true,
  },
  {
    id: "4",
    name: "OPTIMA REDTOP",
    brand: "OPTIMA",
    price: 459,
    image: "/black-car-battery-rocket-brand.jpg",
    inStock: true,
  },
  {
    id: "5",
    name: "ROCKET 55D31L",
    brand: "ROCKET",
    price: 449,
    image: "/black-car-battery-rocket-brand.jpg",
    inStock: true,
  },
  {
    id: "6",
    name: "ROCKET 55D31R",
    brand: "ROCKET",
    price: 449,
    image: "/black-car-battery-rocket-brand.jpg",
    inStock: true,
  },
  {
    id: "7",
    name: "ROCKET 65D31R",
    brand: "ROCKET",
    price: 529,
    image: "/black-car-battery-rocket-brand.jpg",
    inStock: true,
  },
  {
    id: "8",
    name: "WILLARD MF75D31R",
    brand: "WILLARD",
    price: 649,
    image: "/black-car-battery-willard-brand.jpg",
    inStock: true,
  },
]

export function ProductCatalog() {
  const { addItem } = useCart()

  const handleAddToCart = (battery: (typeof batteries)[0]) => {
    addItem({
      id: battery.id,
      name: battery.name,
      price: battery.price,
      image: battery.image,
      model: battery.brand,
    })
  }

  return (
    <section id="productos" className="py-16 bg-gray-50">
      <div className="container mx-auto px-4">
        <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
          {batteries.map((battery) => (
            <Card
              key={battery.id}
              className="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden hover:shadow-md transition-shadow"
            >
              <CardContent className="p-0">
                <Link href={`/producto/${battery.id}`}>
                  <div className="relative cursor-pointer p-4">
                    <img
                      src={battery.image || "/placeholder.svg"}
                      alt={battery.name}
                      className="w-full h-40 object-contain hover:scale-105 transition-transform"
                    />
                  </div>
                </Link>

                <div className="p-4 pt-0">
                  <Link href={`/producto/${battery.id}`}>
                    <h3 className="font-semibold text-base mb-2 hover:text-blue-600 cursor-pointer text-gray-800">
                      {battery.name}
                    </h3>
                  </Link>

                  <div className="flex items-center justify-between mb-4">
                    <span className="text-xl font-bold text-gray-800">S/ {battery.price}</span>
                  </div>

                  <Button
                    className="w-full bg-blue-600 hover:bg-blue-700 text-white text-sm font-medium rounded-md"
                    size="sm"
                  >
                    Ver Detalles
                  </Button>
                </div>
              </CardContent>
            </Card>
          ))}
        </div>

        <div className="text-center mt-12">
          <h2 className="text-2xl font-bold mb-8">OBTÉN TU BATERÍA IDEAL EN 3 SIMPLES PASOS</h2>
        </div>
      </div>
    </section>
  )
}
