"use client"

import { useState } from "react"
import { Button } from "@/components/ui/button"
import { Badge } from "@/components/ui/badge"
import { ShoppingCart, Menu, X, Phone, Mail } from "lucide-react"
import { useCart } from "@/components/cart-context"
import { CartDrawer } from "@/components/cart-drawer"
import Image from "next/image"

export function Header() {
  const [isMenuOpen, setIsMenuOpen] = useState(false)
  const [isCartOpen, setIsCartOpen] = useState(false)
  const { getTotalItems } = useCart()

  const handleCartClick = () => {
    console.log("[v0] Cart button clicked, total items:", getTotalItems())
    console.log("[v0] Setting cart open to true")
    setIsCartOpen(true)
  }

  const scrollToSection = (sectionId: string) => {
    if (sectionId === "inicio") {
      window.scrollTo({ top: 0, behavior: "smooth" })
    } else {
      const element = document.getElementById(sectionId)
      if (element) {
        element.scrollIntoView({ behavior: "smooth" })
      }
    }
    setIsMenuOpen(false)
  }

  return (
    <>
      <header className="bg-white shadow-sm border-b fixed top-0 left-0 right-0 z-50">
        <div className="bg-primary text-primary-foreground py-2">
          <div className="container mx-auto px-4 flex justify-between items-center text-sm">
            <div className="flex items-center gap-4">
              <span className="bg-accent px-3 py-1 rounded-full text-xs font-semibold">¡Llama Ahora!</span>
              <div className="hidden md:flex items-center gap-4">
                <div className="flex items-center gap-1">
                  <Phone className="w-4 h-4" />
                  <span>+51 999 888 777</span>
                </div>
                <div className="flex items-center gap-1">
                  <Mail className="w-4 h-4" />
                  <span>ventas@cambiatubateria.com</span>
                </div>
              </div>
            </div>
            <div className="text-right">
              <span className="font-semibold">ventas@cambiatubateria.com</span>
            </div>
          </div>
        </div>

        <div className="container mx-auto px-4 py-2">
          <div className="flex items-center justify-between">
            <div className="flex items-center">
              <Image
                src="/images/logo-cambia-tu-bateria-nuevo.png"
                alt="Cambia Tu Batería"
                width={400}
                height={120}
                className="h-24 w-auto cursor-pointer"
                priority
                onClick={() => scrollToSection("inicio")}
              />
            </div>

            <nav className="hidden md:flex items-center space-x-8">
              <button
                onClick={() => scrollToSection("inicio")}
                className="text-foreground hover:text-primary font-medium transition-colors"
              >
                INICIO
              </button>
              <button
                onClick={() => scrollToSection("productos")}
                className="text-foreground hover:text-primary font-medium transition-colors"
              >
                CATÁLOGO
              </button>
              <button
                onClick={() => scrollToSection("pasos")}
                className="text-foreground hover:text-primary font-medium transition-colors"
              >
                CÓMO COMPRAR
              </button>
              <button
                onClick={() => scrollToSection("contacto")}
                className="text-foreground hover:text-primary font-medium transition-colors"
              >
                CONTACTO
              </button>
              <button
                onClick={() => scrollToSection("nosotros")}
                className="text-foreground hover:text-primary font-medium transition-colors"
              >
                QUIÉNES SOMOS
              </button>
            </nav>

            <div className="flex items-center gap-4">
              <Button
                variant="outline"
                size="sm"
                className="relative bg-transparent border-primary hover:bg-primary hover:text-primary-foreground"
                onClick={handleCartClick}
              >
                <ShoppingCart className="w-4 h-4" />
                {getTotalItems() > 0 && (
                  <Badge className="absolute -top-2 -right-2 bg-accent text-accent-foreground min-w-[20px] h-5 flex items-center justify-center text-xs font-bold rounded-full">
                    {getTotalItems()}
                  </Badge>
                )}
              </Button>

              <Button variant="ghost" size="sm" className="md:hidden" onClick={() => setIsMenuOpen(!isMenuOpen)}>
                {isMenuOpen ? <X className="w-5 h-5" /> : <Menu className="w-5 h-5" />}
              </Button>
            </div>
          </div>

          {isMenuOpen && (
            <nav className="md:hidden mt-4 pb-4 border-t pt-4">
              <div className="flex flex-col space-y-3">
                <button
                  onClick={() => scrollToSection("inicio")}
                  className="text-foreground hover:text-primary font-medium text-left"
                >
                  INICIO
                </button>
                <button
                  onClick={() => scrollToSection("productos")}
                  className="text-foreground hover:text-primary font-medium text-left"
                >
                  CATÁLOGO
                </button>
                <button
                  onClick={() => scrollToSection("pasos")}
                  className="text-foreground hover:text-primary font-medium text-left"
                >
                  CÓMO COMPRAR
                </button>
                <button
                  onClick={() => scrollToSection("contacto")}
                  className="text-foreground hover:text-primary font-medium text-left"
                >
                  CONTACTO
                </button>
                <button
                  onClick={() => scrollToSection("nosotros")}
                  className="text-foreground hover:text-primary font-medium text-left"
                >
                  QUIÉNES SOMOS
                </button>
              </div>
            </nav>
          )}
        </div>
      </header>

      <div className="h-[120px]"></div>

      <CartDrawer
        isOpen={isCartOpen}
        onClose={() => {
          console.log("[v0] Closing cart drawer")
          setIsCartOpen(false)
        }}
      />
    </>
  )
}
