"use client"

import type React from "react"

import { useState } from "react"
import { Button } from "@/components/ui/button"
import { Input } from "@/components/ui/input"
import { Textarea } from "@/components/ui/textarea"
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"

export function ContactSection() {
  const [formData, setFormData] = useState({
    nombre: "",
    telefono: "",
    mensaje: "",
  })

  const handleSubmit = (e: React.FormEvent) => {
    e.preventDefault()

    const message = `Hola, mi nombre es ${formData.nombre}.\n\nTeléfono: ${formData.telefono}\n\nConsulta: ${formData.mensaje}`
    const encodedMessage = encodeURIComponent(message)
    const whatsappUrl = `https://wa.me/51999888777?text=${encodedMessage}`

    window.open(whatsappUrl, "_blank")

    // Reset form
    setFormData({ nombre: "", telefono: "", mensaje: "" })
  }

  const handleChange = (e: React.ChangeEvent<HTMLInputElement | HTMLTextAreaElement>) => {
    setFormData((prev) => ({
      ...prev,
      [e.target.name]: e.target.value,
    }))
  }

  return (
    <section id="contacto" className="py-16 bg-foreground text-background">
      <div
        className="absolute inset-0 bg-cover bg-center bg-no-repeat opacity-20"
        style={{
          backgroundImage: `url('/mechanic-working-on-car-in-dark-garage.jpg')`,
        }}
      />

      <div className="relative container mx-auto px-4">
        <div className="text-center mb-12">
          <h2 className="text-3xl font-bold mb-4 text-background">
            ESCRÍBENOS Y RECIBE TODA LA ASESORÍA QUE NECESITES
          </h2>
        </div>

        <div className="max-w-2xl mx-auto">
          <Card className="bg-background/95 backdrop-blur">
            <CardHeader>
              <CardTitle className="text-center text-foreground">Contáctanos</CardTitle>
            </CardHeader>
            <CardContent>
              <form onSubmit={handleSubmit} className="space-y-4">
                <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
                  <Input name="nombre" placeholder="Nombre" value={formData.nombre} onChange={handleChange} required />
                  <Input
                    name="telefono"
                    placeholder="Teléfono"
                    value={formData.telefono}
                    onChange={handleChange}
                    required
                  />
                </div>
                <Textarea
                  name="mensaje"
                  placeholder="Mensaje"
                  rows={4}
                  value={formData.mensaje}
                  onChange={handleChange}
                  required
                />
                <Button type="submit" className="w-full bg-accent hover:bg-accent/90 text-accent-foreground">
                  Enviar
                </Button>
              </form>
            </CardContent>
          </Card>
        </div>
      </div>
    </section>
  )
}
