export function BrandsSection() {
  const brands = [
    { name: "ETNA", logo: "/etna-battery-brand-logo.jpg" },
    { name: "ENERTEC", logo: "/enertec-battery-brand-logo.jpg" },
    { name: "CAPSA", logo: "/capsa-battery-brand-logo.jpg" },
    { name: "BOSCH", logo: "/bosch-battery-brand-logo.jpg" },
    { name: "YUASA", logo: "/yuasa-battery-brand-logo.jpg" },
    { name: "RECORD", logo: "/record-battery-brand-logo.jpg" },
    { name: "ROCKET", logo: "/rocket-battery-brand-logo.jpg" },
    { name: "SOLITE", logo: "/solite-battery-brand-logo.jpg" },
    { name: "VARTA", logo: "/varta-battery-brand-logo.jpg" },
  ]

  return (
    <section className="py-16 bg-muted">
      <div className="container mx-auto px-4">
        <div className="text-center mb-12">
          <h2 className="text-2xl font-bold mb-4">Marcas de Confianza</h2>
          <p className="text-muted-foreground">Trabajamos con las mejores marcas del mercado</p>
        </div>

        <div className="grid grid-cols-3 md:grid-cols-5 lg:grid-cols-9 gap-8 items-center">
          {brands.map((brand) => (
            <div key={brand.name} className="flex justify-center">
              <img
                src={brand.logo || "/placeholder.svg"}
                alt={brand.name}
                className="h-20 w-auto object-contain opacity-70 hover:opacity-100 transition-opacity"
              />
            </div>
          ))}
        </div>
      </div>
    </section>
  )
}
