"use client"

import { useState } from "react"
import { Button } from "@/components/ui/button"
import { Select, SelectContent, SelectItem, SelectTrigger, SelectValue } from "@/components/ui/select"

const marcasData = {
  toyota: {
    name: "Toyota",
    modelos: {
      corolla: { name: "Corolla", años: ["2020", "2021", "2022", "2023", "2024"] },
      camry: { name: "Camry", años: ["2019", "2020", "2021", "2022", "2023"] },
      rav4: { name: "RAV4", años: ["2018", "2019", "2020", "2021", "2022", "2023"] },
      hilux: { name: "Hilux", años: ["2017", "2018", "2019", "2020", "2021", "2022", "2023"] },
    },
  },
  nissan: {
    name: "Nissan",
    modelos: {
      sentra: { name: "Sentra", años: ["2019", "2020", "2021", "2022", "2023"] },
      altima: { name: "Altima", años: ["2018", "2019", "2020", "2021", "2022"] },
      xtrail: { name: "X-Trail", años: ["2017", "2018", "2019", "2020", "2021", "2022"] },
      frontier: { name: "Frontier", años: ["2016", "2017", "2018", "2019", "2020", "2021"] },
    },
  },
  hyundai: {
    name: "Hyundai",
    modelos: {
      accent: { name: "Accent", años: ["2018", "2019", "2020", "2021", "2022", "2023"] },
      elantra: { name: "Elantra", años: ["2017", "2018", "2019", "2020", "2021", "2022"] },
      tucson: { name: "Tucson", años: ["2016", "2017", "2018", "2019", "2020", "2021", "2022"] },
    },
  },
  kia: {
    name: "Kia",
    modelos: {
      rio: { name: "Rio", años: ["2018", "2019", "2020", "2021", "2022", "2023"] },
      cerato: { name: "Cerato", años: ["2017", "2018", "2019", "2020", "2021", "2022"] },
      sportage: { name: "Sportage", años: ["2016", "2017", "2018", "2019", "2020", "2021", "2022"] },
    },
  },
  chevrolet: {
    name: "Chevrolet",
    modelos: {
      spark: { name: "Spark", años: ["2018", "2019", "2020", "2021", "2022", "2023"] },
      sail: { name: "Sail", años: ["2017", "2018", "2019", "2020", "2021"] },
      cruze: { name: "Cruze", años: ["2016", "2017", "2018", "2019", "2020", "2021"] },
    },
  },
}

export function BatteryFinder() {
  const [marca, setMarca] = useState("")
  const [modelo, setModelo] = useState("")
  const [año, setAño] = useState("")

  const handleSearch = () => {
    document.getElementById("catalogo")?.scrollIntoView({ behavior: "smooth" })
  }

  const handleMarcaChange = (value: string) => {
    setMarca(value)
    setModelo("")
    setAño("")
  }

  const handleModeloChange = (value: string) => {
    setModelo(value)
    setAño("")
  }

  const selectedMarcaData = marca ? marcasData[marca as keyof typeof marcasData] : null
  const selectedModeloData =
    modelo && selectedMarcaData ? selectedMarcaData.modelos[modelo as keyof typeof selectedMarcaData.modelos] : null

  return (
    <section className="bg-muted py-16">
      <div className="container mx-auto px-4">
        <div className="text-center mb-12">
          <h2 className="text-3xl font-bold mb-4">ENCUENTRA TU BATERÍA SEGÚN LA MARCA Y MODELO DE TU VEHÍCULO</h2>
        </div>

        <div className="max-w-4xl mx-auto">
          <div className="grid grid-cols-1 md:grid-cols-4 gap-4 items-end">
            <div>
              <label className="block text-sm font-medium mb-2">Marca</label>
              <Select value={marca} onValueChange={handleMarcaChange}>
                <SelectTrigger>
                  <SelectValue placeholder="Seleccionar marca" />
                </SelectTrigger>
                <SelectContent>
                  {Object.entries(marcasData).map(([key, data]) => (
                    <SelectItem key={key} value={key}>
                      {data.name}
                    </SelectItem>
                  ))}
                </SelectContent>
              </Select>
            </div>

            <div>
              <label className="block text-sm font-medium mb-2">Modelo</label>
              <Select value={modelo} onValueChange={handleModeloChange} disabled={!marca}>
                <SelectTrigger>
                  <SelectValue placeholder="Seleccionar modelo" />
                </SelectTrigger>
                <SelectContent>
                  {selectedMarcaData &&
                    Object.entries(selectedMarcaData.modelos).map(([key, data]) => (
                      <SelectItem key={key} value={key}>
                        {data.name}
                      </SelectItem>
                    ))}
                </SelectContent>
              </Select>
            </div>

            <div>
              <label className="block text-sm font-medium mb-2">Año</label>
              <Select value={año} onValueChange={setAño} disabled={!modelo}>
                <SelectTrigger>
                  <SelectValue placeholder="Seleccionar año" />
                </SelectTrigger>
                <SelectContent>
                  {selectedModeloData &&
                    selectedModeloData.años.map((year) => (
                      <SelectItem key={year} value={year}>
                        {year}
                      </SelectItem>
                    ))}
                </SelectContent>
              </Select>
            </div>

            <Button onClick={handleSearch} className="bg-accent hover:bg-accent/90 text-accent-foreground h-10">
              Filtrar
            </Button>
          </div>
        </div>
      </div>
    </section>
  )
}
