<?php
include 'header.php';
include '../db.php';

/* -----------------------------------------------------------
   Eliminar producto (opcional)
----------------------------------------------------------- */
if (isset($_GET['del'])) {
  $id = (int)$_GET['del'];

  // borrar compatibilidades
  $stmt = $conn->prepare("DELETE FROM producto_modelo WHERE producto_id=?");
  $stmt->bind_param("i", $id);
  $stmt->execute();

  // borrar imagen del disco
  $imgRow = $conn->query("SELECT imagen FROM productos WHERE id=".$id)->fetch_assoc();
  $img = $imgRow['imagen'] ?? '';
  if ($img && file_exists("../uploads/".$img)) { @unlink("../uploads/".$img); }

  // borrar producto
  $stmt = $conn->prepare("DELETE FROM productos WHERE id=?");
  $stmt->bind_param("i", $id);
  $stmt->execute();

  header("Location: productos.php");
  exit;
}

/* -----------------------------------------------------------
   Filtros simples (busqueda por nombre)
----------------------------------------------------------- */
$search = trim($_GET['q'] ?? '');
$where  = '';
$bind   = null;
if ($search !== '') {
  $where = "WHERE nombre LIKE ?";
}

/* -----------------------------------------------------------
   Traer productos (usa columnas nuevas con respaldo)
----------------------------------------------------------- */
$sql = "
  SELECT
    id,
    nombre,
    capacidad,
    cca,
    imagen,
    COALESCE(precio_sin_bateria, precioMin, 0) AS sin_bat,
    COALESCE(precio_con_bateria, precioMax, 0) AS con_bat
  FROM productos
  ".($where ?: '')."
  ORDER BY id DESC
";

if ($where) {
  $stmt = $conn->prepare($sql);
  $like = "%{$search}%";
  $stmt->bind_param("s", $like);
  $stmt->execute();
  $q = $stmt->get_result();
} else {
  $q = $conn->query($sql);
}

/* -----------------------------------------------------------
   Helpers
----------------------------------------------------------- */
function soles($n) {
  $n = (float)$n;
  return $n > 0 ? ('S/ '.number_format($n, 2, '.', ',')) : '';
}
?>
<div class="container-fluid px-2 px-lg-3">

  <div class="d-flex flex-column flex-lg-row gap-2 justify-content-between align-items-lg-center mb-3">
    <h1 class="h3 mb-0">Productos</h1>

    <form class="d-flex gap-2" method="get">
      <input type="text" name="q" value="<?= htmlspecialchars($search) ?>" class="form-control" placeholder="Buscar por nombre...">
      <?php if ($search !== ''): ?>
        <a class="btn btn-outline-secondary" href="productos.php"><i class="fa fa-xmark"></i></a>
      <?php endif; ?>
      <button class="btn btn-outline-primary"><i class="fa fa-search"></i></button>
      <a class="btn btn-success" href="nuevo_producto.php"><i class="fa fa-plus me-1"></i> Nuevo producto</a>
    </form>
  </div>

  <div class="card shadow-sm">
    <div class="card-body table-responsive">
      <table class="table align-middle">
        <thead class="table-dark">
          <tr>
            <th style="width:70px">ID</th>
            <th>Nombre</th>
            <th style="width:260px">Precio</th>
            <th style="width:120px">Capacidad</th>
            <th style="width:100px">CCA</th>
            <th style="width:120px">Imagen</th>
            <th style="width:180px" class="text-end">Acciones</th>
          </tr>
        </thead>
        <tbody>
        <?php if ($q && $q->num_rows): ?>
          <?php while($p = $q->fetch_assoc()): ?>
            <?php
              $sin = (float)($p['sin_bat'] ?? 0);
              $con = (float)($p['con_bat'] ?? 0);

              if ($sin > 0 && $con > 0) {
                $precio = soles($sin).' – '.soles($con);
              } elseif ($sin > 0) {
                $precio = soles($sin).' <small class="text-muted">(sin bateria)</small>';
              } elseif ($con > 0) {
                $precio = soles($con).' <small class="text-muted">(con bateria)</small>';
              } else {
                $precio = '<span class="text-muted">—</span>';
              }

              $thumb = !empty($p['imagen'])
                ? '../uploads/'.htmlspecialchars($p['imagen'])
                : 'https://via.placeholder.com/90x90?text=Sin+img';
            ?>
            <tr>
              <td><?= (int)$p['id'] ?></td>
              <td><?= htmlspecialchars($p['nombre']) ?></td>
              <td><?= $precio ?></td>
              <td><?= htmlspecialchars($p['capacidad'] ?: '—') ?></td>
              <td><?= htmlspecialchars($p['cca'] ?: '—') ?></td>
              <td>
                <img src="<?= $thumb ?>" alt="img" style="height:70px; object-fit:cover; border-radius:6px;">
              </td>
              <td class="text-end">
                <a class="btn btn-sm btn-warning" href="editar_producto.php?id=<?= (int)$p['id'] ?>">
                  <i class="fa fa-pen"></i> Editar
                </a>
                <a class="btn btn-sm btn-danger" href="productos.php?del=<?= (int)$p['id'] ?>"
                   onclick="return confirm('¿Eliminar este producto?');">
                  <i class="fa fa-trash"></i> Eliminar
                </a>
              </td>
            </tr>
          <?php endwhile; ?>
        <?php else: ?>
            <tr>
              <td colspan="7">
                <div class="text-center py-5">
                  <i class="fa-regular fa-box-open fa-2x mb-2 text-muted"></i>
                  <div class="text-muted">No hay productos para mostrar.</div>
                </div>
              </td>
            </tr>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<?php include 'footer.php'; ?>

