<?php
header('Content-Type: application/json; charset=UTF-8');

// db.php esta en backend/db.php (subimos 1 nivel)
require_once __DIR__ . '/../db.php';

$marca_id = isset($_GET['marca_id']) ? (int)$_GET['marca_id'] : 0;
$out = [];

if ($marca_id > 0) {
  $stmt = $conn->prepare("
    SELECT id, nombre, anio
    FROM modelos
    WHERE marca_id = ?
    ORDER BY nombre, anio DESC
  ");
  $stmt->bind_param("i", $marca_id);
  $stmt->execute();
  $res = $stmt->get_result();
  while ($r = $res->fetch_assoc()) {
    $out[] = [
      'id'     => (int)$r['id'],
      'nombre' => $r['nombre'],
      'anio'   => (int)$r['anio'],
      'label'  => trim($r['nombre'].' '.$r['anio']),
    ];
  }
}

echo json_encode($out);
exit;
