<?php
include 'header.php';
include '../db.php';

/* -------------------------------------------
   Eliminar producto (con limpieza de vínculos)
-------------------------------------------- */
if (isset($_GET['del'])) {
  $id = (int)$_GET['del'];

  // borrar compatibilidades
  $stmt = $conn->prepare("DELETE FROM producto_modelo WHERE producto_id=?");
  $stmt->bind_param("i", $id);
  $stmt->execute();

  // borrar imagen física
  $imgRow = $conn->query("SELECT imagen FROM productos WHERE id=".$id)->fetch_assoc();
  $img = $imgRow['imagen'] ?? '';
  if ($img && file_exists("../uploads/".$img)) { @unlink("../uploads/".$img); }

  // borrar producto
  $stmt = $conn->prepare("DELETE FROM productos WHERE id=?");
  $stmt->bind_param("i", $id);
  $stmt->execute();

  header("Location: productos.php");
  exit;
}

/* -------------------------------------------
   Filtro por nombre
-------------------------------------------- */
$search = trim($_GET['q'] ?? '');
$where  = '';
$params = [];
$types  = '';

if ($search !== '') {
  $where   = "WHERE nombre LIKE ?";
  $params[] = "%{$search}%";
  $types   .= "s";
}

/* -------------------------------------------
   Consulta (solo columnas nuevas)
-------------------------------------------- */
$sql = "
  SELECT
    id,
    nombre,
    IFNULL(precio_sin_bateria, 0) AS sin_bat,
    IFNULL(precio_con_bateria, 0) AS con_bat,
    capacidad,
    cca,
    imagen
  FROM productos
  ".($where ?: '')."
  ORDER BY id DESC
";

if ($where) {
  $stmt = $conn->prepare($sql);
  $stmt->bind_param($types, ...$params);
  $stmt->execute();
  $res = $stmt->get_result();
} else {
  $res = $conn->query($sql);
}

$total = $res ? $res->num_rows : 0;

/* -------------------------------------------
   Helpers
-------------------------------------------- */
function soles($n) {
  $n = (float)$n;
  return $n > 0 ? ('S/ '.number_format($n, 2, '.', ',')) : '—';
}
?>
<style>
  .tbl-head-sticky thead th { position: sticky; top: 0; z-index: 1; }
  .thumb { height: 56px; width: 90px; object-fit: cover; border-radius: 8px; border:1px solid #e9ecef; }
  .price-badge { font-weight: 600; }
</style>

<div class="container-fluid px-2 px-lg-3">

  <!-- Barra superior -->
  <div class="d-flex flex-column flex-lg-row gap-2 justify-content-between align-items-lg-center mb-3">
    <div class="d-flex align-items-baseline gap-3">
      <h1 class="h3 mb-0">Productos</h1>
      <span class="badge bg-dark-subtle text-dark-emphasis">Total: <?= (int)$total ?></span>
    </div>

    <form class="d-flex gap-2" method="get" role="search">
      <input type="text" name="q" value="<?= htmlspecialchars($search) ?>" class="form-control"
             placeholder="Buscar por nombre…">
      <?php if ($search !== ''): ?>
        <a class="btn btn-outline-secondary" href="productos.php" title="Limpiar"><i class="fa fa-xmark"></i></a>
      <?php endif; ?>
      <button class="btn btn-outline-primary" title="Buscar"><i class="fa fa-search"></i></button>
      <a class="btn btn-success" href="nuevo_producto.php">
        <i class="fa fa-plus me-1"></i> Nuevo producto
      </a>
    </form>
  </div>

  <!-- Tabla -->
  <div class="card shadow-sm">
    <div class="card-body table-responsive tbl-head-sticky" style="max-height: 70vh;">
      <table class="table table-hover align-middle mb-0">
        <thead class="table-dark">
          <tr>
            <th style="width:70px">ID</th>
            <th>Nombre</th>
            <th style="width:180px">Precio SIN batería</th>
            <th style="width:180px">Precio CON batería</th>
            <th style="width:120px">Capacidad</th>
            <th style="width:100px">CCA</th>
            <th style="width:130px">Imagen</th>
            <th style="width:180px" class="text-end">Acciones</th>
          </tr>
        </thead>
        <tbody>
        <?php if ($res && $res->num_rows): ?>
          <?php while($p = $res->fetch_assoc()): ?>
            <?php
              $img = !empty($p['imagen'])
                ? '../uploads/'.htmlspecialchars($p['imagen'])
                : 'https://via.placeholder.com/90x56?text=Sin+img';

              $precioSin = (float)$p['sin_bat'];
              $precioCon = (float)$p['con_bat'];

              $badgeSin = $precioSin > 0
                ? '<span class="badge text-bg-secondary price-badge">'.soles($precioSin).'</span>'
                : '<span class="text-muted">—</span>';

              $badgeCon = $precioCon > 0
                ? '<span class="badge text-bg-success price-badge">'.soles($precioCon).'</span>'
                : '<span class="text-muted">—</span>';
            ?>
            <tr>
              <td><?= (int)$p['id'] ?></td>
              <td class="fw-semibold"><?= htmlspecialchars($p['nombre']) ?></td>
              <td><?= $badgeSin ?> <small class="text-muted d-block d-lg-inline">(sin batería)</small></td>
              <td><?= $badgeCon ?> <small class="text-muted d-block d-lg-inline">(con batería)</small></td>
              <td><?= htmlspecialchars($p['capacidad'] ?: '—') ?></td>
              <td><?= htmlspecialchars($p['cca'] ?: '—') ?></td>
              <td>
                <img src="<?= $img ?>" class="thumb" alt="img">
              </td>
              <td class="text-end">
                <div class="btn-group">
                  <a class="btn btn-sm btn-warning" href="editar_producto.php?id=<?= (int)$p['id'] ?>">
                    <i class="fa fa-pen"></i> Editar
                  </a>
                  <a class="btn btn-sm btn-danger"
                     href="productos.php?del=<?= (int)$p['id'] ?>"
                     onclick="return confirm('¿Eliminar este producto?');">
                    <i class="fa fa-trash"></i> Eliminar
                  </a>
                </div>
              </td>
            </tr>
          <?php endwhile; ?>
        <?php else: ?>
            <tr>
              <td colspan="8">
                <div class="text-center py-5">
                  <i class="fa-regular fa-box-open fa-2x mb-2 text-muted"></i>
                  <div class="text-muted">No hay productos para mostrar.</div>
                </div>
              </td>
            </tr>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<?php include 'footer.php'; ?>
